<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Status Pesanan Diperbarui</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }
        .container {
            max-width: 600px;
            margin: 20px auto;
            background: #ffffff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        h2 {
            color: #333;
            text-align: center;
        }
        p {
            font-size: 14px;
            color: #555;
            line-height: 1.6;
        }
        .order-details {
            background: #f9f9f9;
            padding: 15px;
            border-radius: 5px;
            margin-top: 15px;
        }
        .order-details ul {
            list-style: none;
            padding: 0;
        }
        .order-details li {
            padding: 8px 0;
            border-bottom: 1px solid #ddd;
        }
        .order-details li:last-child {
            border-bottom: none;
        }
        .button {
            display: block;
            width: 100%;
            text-align: center;
            background: #007bff;
            color: white;
            text-decoration: none;
            padding: 12px;
            border-radius: 5px;
            font-weight: bold;
            margin-top: 20px;
        }
        .button:hover {
            background: #0056b3;
        }
        .footer {
            text-align: center;
            font-size: 12px;
            color: #777;
            margin-top: 20px;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Halo, {{ $order->email }}</h2>
        <p>Status pesanan Anda dengan <strong>Order ID:</strong> <code>{{ $order->order_id }}</code> telah diperbarui.</p>
        
        <div class="order-details">
            <h3>Detail Pesanan:</h3>
            <ul>
                <li><strong>Game:</strong> {{ $order->games }}</li>
                <li><strong>Produk:</strong> {{ $order->product }}</li>
                <li><strong>Harga:</strong> Rp{{ number_format($order->price, 0, ',', '.') }}</li>
                <li><strong>Metode Pembayaran:</strong> {{ $order->payment_name }}</li>
                <li><strong>Status Terbaru:</strong> <span style="color: {{ $order->buy_status == 'Sukses' ? 'green' : ($order->buy_status == 'Gagal' ? 'red' : 'orange') }};">{{ $order->buy_status }}</span></li>
                @isset($order->serial_number)
                <li><strong>Serial Number:</strong> <code>{{ $order->serial_number }}</code></li>
                @endisset
            </ul>
        </div>

        <a href="{{ config('app.front_url') . '/invoices/' . $order->order_id }}" class="button">Lihat Detail Pesanan</a>

        <p class="footer">Terima kasih telah melakukan pembelian di <strong>{{ config('app.name') }}</strong>.</p>
    </div>
</body>
</html>