<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('orders', function (Blueprint $table) {
            $table->string('qrispy_qris_id')->nullable()->after('payment_code');
            $table->text('qrispy_image_url')->nullable()->after('qrispy_qris_id');
            $table->longText('qrispy_image_base64')->nullable()->after('qrispy_image_url');
            $table->timestamp('qrispy_expires_at')->nullable()->after('expired_time');
            $table->timestamp('qrispy_paid_at')->nullable()->after('qrispy_expires_at');
            $table->string('qrispy_webhook_unique_id')->nullable()->after('qrispy_paid_at');

            $table->index('qrispy_qris_id');
            $table->index('qrispy_webhook_unique_id');
        });
    }

    public function down(): void
    {
        Schema::table('orders', function (Blueprint $table) {
            $table->dropIndex(['qrispy_qris_id']);
            $table->dropIndex(['qrispy_webhook_unique_id']);
            $table->dropColumn([
                'qrispy_qris_id',
                'qrispy_image_url',
                'qrispy_image_base64',
                'qrispy_expires_at',
                'qrispy_paid_at',
                'qrispy_webhook_unique_id',
            ]);
        });
    }
};