<?php

use App\Models\Setting;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    public function up(): void
    {
        $defaults = [
            'otp.length' => '6',
            'otp.expiry_minutes' => '5',
            'otp.max_attempts' => '5',
            'otp.resend_cooldown_seconds' => '60',
            'notification.enabled.otp_login' => true,
            'notification.enabled.otp_register' => true,
            'notification.templates.otp_login' => "*{app_name} - OTP Login*\n\nKode OTP kamu: *{otp_code}*\nBerlaku selama *{expires_minutes} menit*.\n\nJika kamu tidak merasa melakukan login, abaikan pesan ini.\n\nTerima kasih, {app_name}",
            'notification.templates.otp_register' => "*{app_name} - OTP Daftar*\n\nKode OTP kamu: *{otp_code}*\nBerlaku selama *{expires_minutes} menit*.\n\nJangan bagikan kode ini ke siapa pun.\n\nTerima kasih, {app_name}",
        ];

        foreach ($defaults as $key => $value) {
            if (Setting::where('key', $key)->exists()) {
                continue;
            }

            Setting::create([
                'key' => $key,
                'value' => $value,
            ]);
        }
    }

    public function down(): void
    {
    }
};