<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('otp_codes')) {
            return;
        }

        Schema::create('otp_codes', function (Blueprint $table) {
            $table->id();
            $table->string('whatsapp');
            $table->string('purpose');
            $table->string('otp_hash');
            $table->timestamp('expires_at');
            $table->timestamp('resend_available_at')->nullable();
            $table->unsignedInteger('attempts')->default(0);
            $table->unsignedInteger('max_attempts')->default(5);
            $table->string('ip')->nullable();
            $table->text('user_agent')->nullable();
            $table->timestamp('consumed_at')->nullable();
            $table->timestamps();

            $table->index(['whatsapp', 'purpose']);
            $table->index('expires_at');
            $table->index('consumed_at');
        });
    }

    public function down(): void
    {
        if (! Schema::hasTable('otp_codes')) {
            return;
        }

        Schema::dropIfExists('otp_codes');
    }
};