<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('orders', function (Blueprint $table) {
            $table->unsignedBigInteger('promo_code_id')->nullable()->after('code_voucher');
            $table->string('promo_code')->nullable()->after('promo_code_id');
            $table->bigInteger('promo_discount')->nullable()->after('discount_price');
            $table->index('promo_code_id');
        });
    }

    public function down(): void
    {
        Schema::table('orders', function (Blueprint $table) {
            $table->dropIndex(['promo_code_id']);
            $table->dropColumn(['promo_code_id', 'promo_code', 'promo_discount']);
        });
    }
};