<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('promo_code_payment_method', function (Blueprint $table) {
            $table->unsignedBigInteger('promo_code_id');
            $table->unsignedBigInteger('payment_method_id');
            $table->timestamps();

            $table->primary(['promo_code_id', 'payment_method_id']);
            $table->foreign('promo_code_id')->references('id')->on('promo_codes')->cascadeOnDelete();
            $table->foreign('payment_method_id')->references('id')->on('payment_methods')->cascadeOnDelete();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('promo_code_payment_method');
    }
};