<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('smp_qris_callbacks', function (Blueprint $t) {
            $t->id();
            $t->string('rrn')->unique();
            $t->string('us_username')->nullable();
            $t->string('tr_id')->nullable();
            $t->string('issuer')->nullable();
            $t->string('payer_name')->nullable();
            $t->string('amount_value')->nullable();
            $t->bigInteger('saldo_akhir')->nullable();
            $t->timestamp('timestamp')->nullable();
            $t->string('matched_order_id')->nullable();
            $t->unsignedBigInteger('qris_payment_id')->nullable();
            $t->json('payload')->nullable();
            $t->timestamps();

            $t->index(['matched_order_id']);
            $t->index(['qris_payment_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('smp_qris_callbacks');
    }
};