<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
  
    public function up(): void
    {
        Schema::table('products', function (Blueprint $table) {
            $table->bigInteger('profit_gold')->nullable()->after('profit');
            $table->bigInteger('profit_platinum')->nullable()->after('profit_gold');
            $table->bigInteger('selling_price_gold')->nullable()->after('selling_price');
            $table->bigInteger('selling_price_platinum')->nullable()->after('selling_price_gold');
        });
    }

    public function down(): void
    {
        Schema::table('products', function (Blueprint $table) {
            $table->dropColumn([
                'profit_gold',
                'profit_platinum',
                'selling_price_gold',
                'selling_price_platinum',
            ]);
        });
    }
};
