<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
      Schema::create('promos', function (Blueprint $table) {
          $table->id();
          $table->string('title');
          $table->text('image_url');
          $table->string('link')->nullable();
          $table->boolean('is_active')->default(true);
          $table->timestamp('start_at')->nullable();
          $table->timestamp('end_at')->nullable();
          $table->timestamps();
      });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('promos');
    }
};
