<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('payment_methods', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('images');
            $table->string('name');
            $table->string('code')->unique();
            $table->string('group');
            $table->string('type');
            $table->unsignedBigInteger('fee')->default(0);
            $table->unsignedBigInteger('fee_percent')->default(0);
            $table->unsignedBigInteger('minimum_amount');
            $table->unsignedBigInteger('maximum_amount');
            $table->boolean('status')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payment_methods');
    }
};
