<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('order_id')->unique();
            $table->unsignedBigInteger('user_id')->nullable()->index('orders_user_id_foreign');
            $table->string('games');
            $table->string('product');
            $table->string('code_product');
            $table->string('id_games');
            $table->string('server_games')->nullable();
            $table->string('nickname')->nullable();
            $table->string('email')->nullable();
            $table->string('whatsapp');
            $table->string('code_voucher')->nullable();
            $table->bigInteger('price');
            $table->bigInteger('discount_price')->nullable();
            $table->bigInteger('profit');
            $table->bigInteger('fee')->nullable();
            $table->bigInteger('total_price');
            $table->string('payment_name');
            $table->string('payment_method');
            $table->string('payment_code');
            $table->string('expired_time');
            $table->enum('payment_status', ['UNPAID', 'PAID', 'EXPIRED', 'FAILED'])->default('UNPAID');
            $table->json('payment_instructions')->nullable();
            $table->enum('buy_status', ['Pending', 'Proses', 'Sukses', 'Batal', 'Gagal', 'Unknown'])->default('Pending');
            $table->string('serial_number')->nullable();
            $table->text('df_message')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('orders');
    }
};
