<?php

namespace App\Services;

use Illuminate\Support\Facades\Http;
use App\Models\Setting;

class QrisSmpClient
{
    public function __construct(
        protected string $username,
        protected string $qrisString,
        protected string $apiKey,
        protected int $expiresMinutes = 30,
        protected int $uniqueDigits = 3,
    ) {}

    public static function fromDb(): self {
        $settings = Setting::all()->pluck('value','key');
        return new self(
            $settings['smp.username']['value'] ?? ($settings['smp.username'] ?? null),
            $settings['smp.qris']['value'] ?? ($settings['smp.qris'] ?? null),
            $settings['smp.apikey']['value'] ?? ($settings['smp.apikey'] ?? null),
            (int)($settings['smp.expires']['value'] ?? ($settings['smp.expires'] ?? 30)),
            (int)($settings['smp.unique_digits']['value'] ?? ($settings['smp.unique_digits'] ?? 3)),
        );
    }

    public function fetchMutations(): array {
        $endpoint = 'https://solusimediapulsa.com/api/h2h-qris';
        $res = Http::timeout(15)->retry(2,300)->get($endpoint, [
            'us_username' => $this->username,
            'us_qris'     => $this->qrisString,
            'api_key'     => $this->apiKey,
        ]);
        if (!$res->ok()) {
            return ['status'=>false,'message'=>'HTTP '.$res->status(),'data'=>[]];
        }
        return $res->json();
    }

    public function qrisString(): string { return $this->qrisString; }
    public function expiresMinutes(): int { return $this->expiresMinutes; }
    public function uniqueDigits(): int { return $this->uniqueDigits; }
}