<?php

namespace App\Services;

use Illuminate\Support\Facades\Http;

class MpwaService
{
    protected string $baseUrl = 'https://wa.maysender.biz.id';

    public function sendMessage(string $apiKey, string $sender, string $number, string $message, ?string $footer = null, ?string $msgid = null, ?int $full = null): array
    {
        $payload = [
            'api_key' => $apiKey,
            'sender' => $sender,
            'number' => $number,
            'message' => $message,
        ];

        if ($footer !== null) {
            $payload['footer'] = $footer;
        }

        if ($msgid !== null) {
            $payload['msgid'] = $msgid;
        }

        if ($full !== null) {
            $payload['full'] = $full;
        }

        $response = Http::asJson()
            ->timeout(20)
            ->post($this->baseUrl . '/send-message', $payload);

        return $response->json() ?? ['status' => false, 'msg' => 'Invalid response'];
    }

    public function getUserInfo(string $apiKey, string $username): array
    {
        $response = Http::asJson()
            ->timeout(20)
            ->post($this->baseUrl . '/info-user', [
                'api_key' => $apiKey,
                'username' => $username,
            ]);

        return $response->json() ?? ['status' => false];
    }

    public function getDeviceInfo(string $apiKey, string $number): array
    {
        $response = Http::asJson()
            ->timeout(20)
            ->post($this->baseUrl . '/info-devices', [
                'api_key' => $apiKey,
                'number' => $number,
            ]);

        return $response->json() ?? ['status' => false];
    }
}