<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Setting extends Model
{
    protected $fillable = ['key', 'value'];
    public $timestamps = true;

    protected $casts = [
        'value' => 'json', // Untuk menangani JSON data
    ];

    // Menambahkan metode getSetting
    public static function getSetting(string $key, mixed $default = null)
    {
        $setting = self::where('key', $key)->first(); // Ambil pengaturan berdasarkan key

        return $setting ? json_decode($setting->value, true) : $default; // Return JSON value
    }
}
