<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class QrisPayment extends Model
{
    use HasFactory;

    protected $fillable = [
        'order_pk','order_id','amount_base','unique_code','amount_total',
        'status','paid_at','expires_at','match_tx_at','match_sender','meta'
    ];

    protected $casts = [
        'meta' => 'array',
        'paid_at' => 'datetime',
        'expires_at' => 'datetime',
    ];

    public function scopePending($q){ return $q->where('status','pending'); }
    public function isExpired(): bool { return now()->greaterThan($this->expires_at); }
}