<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PaymentMethod extends Model
{
    use HasFactory;

    protected $fillable = [
        'images',
        'name',
        'code',
        'group',
        'type',
        'fee',
        'fee_percent',
        'minimum_amount',
        'maximum_amount',
        'provider',
        'status',
        'is_outside_group',
        'badge_text',
        'outside_sort',
    ];

    protected $casts = [
        'status' => 'boolean',
        'is_outside_group' => 'boolean',
    ];
}