<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GameConfiguration extends Model
{
    use HasFactory;

    protected $fillable = [
        'game_name',
        'required_inputs',
        'options',
        'guide_text',
        'guide_image',
        'code_validation_nickname',
        'status_validation_nickname',
        'input_fields'
    ];

    protected $casts = [
        'required_inputs' => 'array',
        'options' => 'array',
        'guide_image' => 'array',
        'input_fields' => 'array',
    ];
}