<?php

namespace App\Jobs;

use App\Services\WhatsAppNotificationService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class SendWhatsAppNotificationJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected string $whatsapp;
    protected string $templateKey;
    protected array $vars;
    protected ?string $message;

    public function __construct(string $whatsapp, string $templateKey, array $vars, ?string $message = null)
    {
        $this->whatsapp = $whatsapp;
        $this->templateKey = $templateKey;
        $this->vars = $vars;
        $this->message = $message;
    }

    public function handle(): void
    {
        app(WhatsAppNotificationService::class)->send(
            $this->whatsapp,
            $this->templateKey,
            $this->vars,
            $this->message
        );
    }
}