<?php

namespace App\Jobs;

use App\Models\Order;
use App\Services\DigiflazzService;
use App\Services\WhatsAppNotificationService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class DigiflazzSyncPendingJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function handle(): void
    {
        $orders = Order::query()
            ->where('payment_status', 'PAID')
            ->where('buy_status', 'Proses')
            ->whereNotNull('df_message')
            ->where('df_message', 'like', '%Pending%')
            ->orderByDesc('id')
            ->limit(50)
            ->get();

        if ($orders->isEmpty()) {
            return;
        }

        $df = app(DigiflazzService::class);
        $wa = app(WhatsAppNotificationService::class);

        foreach ($orders as $order) {
            $prevBuyStatus = (string) ($order->buy_status ?? '');
            $prevSn = trim((string) ($order->serial_number ?? ''));

            $df->syncStatus($order);

            $order->refresh();

            $newBuyStatus = (string) ($order->buy_status ?? '');
            $newSn = trim((string) ($order->serial_number ?? ''));

            if ($prevBuyStatus !== 'Sukses' && $newBuyStatus === 'Sukses' && $prevSn === '' && $newSn !== '') {
                $wa->send(
                    $order->whatsapp,
                    'delivered',
                    [
                        'order_id' => $order->order_id,
                        'games' => $order->games,
                        'product' => $order->product,
                        'id_games' => $order->id_games,
                        'server_games' => $order->server_games,
                        'nickname' => $order->nickname,
                        'price' => $order->price,
                        'fee' => $order->fee,
                        'total_price' => $order->total_price,
                        'payment_name' => $order->payment_name,
                        'payment_method' => $order->payment_method,
                        'payment_code' => $order->payment_code,
                        'payment_status' => $order->payment_status,
                        'buy_status' => $order->buy_status,
                        'expired_time' => $order->expired_time,
                        'invoice_url' => config('app.front_url') . "/invoices/{$order->order_id}",
                        'serial_number' => $order->serial_number,
                        'df_message' => $order->df_message,
                        'app_name' => config('app.name'),
                    ]
                );
            }
        }
    }
}