<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Requests\PromoCodeListRequest;
use App\Http\Requests\PromoCodeValidateRequest;
use App\Services\PromoCodeService;

class PromoCodeController extends Controller
{
    public function index(PromoCodeListRequest $request, PromoCodeService $service)
    {
        return $this->list($request, $service);
    }

    public function validate(PromoCodeValidateRequest $request, PromoCodeService $service)
    {
        return $this->validateCode($request, $service);
    }

    public function validateCode(PromoCodeValidateRequest $request, PromoCodeService $service)
    {
        $user = $request->user();
        $role = $user?->role;
        $userId = $user?->id;

        $gameSlug = (string) ($request->input('game_slug') ?? $request->input('game'));

        $result = $service->validatePromo(
            (string) $request->input('code'),
            $gameSlug,
            (int) $request->input('product_id'),
            (int) $request->input('payment_method_id'),
            $role,
            $userId,
            $request->input('whatsapp')
        );

        if (!($result['valid'] ?? false)) {
            return response()->json([
                'success' => false,
                'message' => $result['message'] ?? 'Kode promo tidak valid.',
            ], 422);
        }

        return response()->json([
            'success' => true,
            'message' => $result['message'] ?? 'Kode promo dapat digunakan.',
            'data' => $result,
        ]);
    }

    public function list(PromoCodeListRequest $request, PromoCodeService $service)
    {
        $user = $request->user();
        $role = $user?->role;

        $gameSlug = $request->query('game_slug')
            ?? $request->query('game')
            ?? $request->input('game_slug')
            ?? $request->input('game');

        $paymentMethodId = $request->query('payment_method_id');
        if ($paymentMethodId === null) $paymentMethodId = $request->input('payment_method_id');

        $productId = $request->query('product_id');
        if ($productId === null) $productId = $request->input('product_id');

        $paymentMethodId = $paymentMethodId !== null && $paymentMethodId !== '' ? (int) $paymentMethodId : null;
        $productId = $productId !== null && $productId !== '' ? (int) $productId : null;

        return response()->json(
            $service->listForPopup(
                $gameSlug ? (string) $gameSlug : null,
                $paymentMethodId,
                $productId,
                $role
            )
        );
    }
}