<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Game;
use App\Models\Product;

class PriceListController extends Controller
{
    public function index()
    {
        $games = Game::all();

        $data = $games->map(function ($game) {
            $products = Product::where('brand', $game->brand)
                ->select('id', 'title', 'brand', 'images', 'selling_price', 'selling_price_gold', 'selling_price_platinum', 'status')
                ->orderBy('selling_price', 'asc')
                ->get();

            return [
                'id' => $game->id,
                'game_name' => $game->title,
                'brand' => $game->brand,
                'slug' => $game->slug,
                'products' => $products->map(function ($product) {
                    $img = $product->images ? asset("storage/{$product->images}") : null;

                    return [
                        'id' => $product->id,
                        'title' => $product->title,
                        'brand' => $product->brand,
                        'images' => $img,
                        'selling_price' => (float) $product->selling_price,
                        'selling_price_gold' => $product->selling_price_gold !== null ? (float) $product->selling_price_gold : null,
                        'selling_price_platinum' => $product->selling_price_platinum !== null ? (float) $product->selling_price_platinum : null,
                        'status' => (int) ((bool) $product->status),
                    ];
                }),
            ];
        })->filter(function ($game) {
            return $game['products']->isNotEmpty();
        })->values();

        return response()->json([
            'success' => true,
            'data' => $data,
        ]);
    }
}
