<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Promo;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;

class PopUpPromoController extends Controller
{
    public function index()
    {
        $now = Carbon::now();

        $promo = Promo::query()
            ->where('is_active', true)
            ->where(function ($query) use ($now) {
                $query->whereNull('start_at')->orWhere('start_at', '<=', $now);
            })
            ->where(function ($query) use ($now) {
                $query->whereNull('end_at')->orWhere('end_at', '>=', $now);
            })
            ->latest('start_at')
            ->first();

        if ($promo) {
            $promo->image_url = $promo->image_url ? asset("storage/{$promo->image_url}") : null;
        }

        return response()->json([
            'success' => true,
            'promo' => $promo,
        ]);
    }
}