<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Game;
use Illuminate\Http\Request;

class GameController extends Controller
{
    public function index()
    {
        $games = Game::with('category')->get();
        $populerGames = Game::where('populer', true)->get();

        foreach ($games as $game) {
            $game->image = $game->image ? asset("storage/{$game->image}") : null;
            $game->banner = $game->banner ? asset("storage/{$game->banner}") : null;
        }

        foreach ($populerGames as $game) {
            $game->image = $game->image ? asset("storage/{$game->image}") : null;
        }

        return response()->json([
            'success' => true,
            'games' => $games,
            'populerGames' => $populerGames,
        ]);
    }

    public function search(Request $request)
    {
        $query = $request->input('search');

        if (!$query) {
            return response()->json(['games' => []], 200);
        }

        $games = Game::where('title', 'LIKE', "%{$query}%")->take(10)->get();

        foreach ($games as $game) {
            $game->image = $game->image ? asset("storage/{$game->image}") : null;
        }

        return response()->json(['games' => $games]);
    }
}

