<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Blog;
use Illuminate\Http\Request;

class BlogController extends Controller
{
    public function index()
    {
        $blogs = Blog::query()
            ->whereNotNull('published_at')
            ->orderByDesc('published_at')
            ->get()
            ->map(function ($blog) {
                return [
                    'id' => $blog->id,
                    'title' => $blog->title,
                    'slug' => $blog->slug,
                    'content' => $blog->content,
                    'image' => $blog->image ? asset("storage/{$blog->image}") : null,
                    'published_at' => $blog->published_at,
                    'views' => $blog->views,
                ];
            });

        return response()->json([
            'success' => true,
            'blogs' => $blogs,
        ]);
    }

    public function show($slug)
    {
        $blog = Blog::where('slug', $slug)->firstOrFail();

        $blog->increment('views');

        return response()->json([
            'success' => true,
            'blog' => [
                'id' => $blog->id,
                'title' => $blog->title,
                'slug' => $blog->slug,
                'content' => $blog->content,
                'image' => $blog->image ? asset("storage/{$blog->image}") : null,
                'published_at' => $blog->published_at,
                'views' => $blog->views,
            ],
        ]);
    }
}