<?php

namespace App\Filament\Resources\TransactionResource\Widgets;

use App\Models\Order;
use Filament\Widgets\StatsOverviewWidget as BaseWidget;
use Filament\Widgets\StatsOverviewWidget\Card;
use Carbon\Carbon;

class TransactionStats extends BaseWidget
{
  
    protected function getCards(): array
    {
        return [
            Card::make('Profit Hari Ini', 'Rp ' . number_format(
                    Order::whereDate('created_at', today())
                        ->where('buy_status', 'Sukses')
                        ->sum('profit'),
                    0,
                    ',',
                    '.'
                )
            )
            ->icon('heroicon-o-banknotes')
            ->description('Total profit hari ini')
            ->color('dark'),
            
            Card::make('Profit Minggu Ini', 'Rp ' . number_format(
                    Order::whereBetween('created_at', [now()->startOfWeek(), now()->endOfWeek()])
                        ->where('buy_status', 'Sukses')
                        ->sum('profit'),
                    0,
                    ',',
                    '.'
                )
            )
            ->icon('heroicon-o-banknotes')
            ->description('Total profit minggu ini')
            ->color('dark'),
            
            Card::make('Profit Bulan Ini', 'Rp ' . number_format(
                    Order::whereBetween('created_at', [now()->startOfMonth(), now()->endOfMonth()])
                        ->where('buy_status', 'Sukses')
                        ->sum('profit'),
                    0,
                    ',',
                    '.'
                )
            )
            ->icon('heroicon-o-banknotes')
            ->description('Total profit bulan ini')
            ->color('dark'),
            
            Card::make('Profit Keseluruhan', 'Rp ' . number_format(
                    Order::where('buy_status', 'Sukses')
                        ->sum('profit'),
                    0,
                    ',',
                    '.'
                )
            )
            ->icon('heroicon-o-banknotes')
            ->description('Total profit keseluruhan')
            ->color('dark'),
            
            Card::make('Transaksi Hari Ini', Order::whereDate('created_at', Carbon::today())->count())
                ->description($this->formatTransactions(Carbon::today(), Carbon::today()))
                ->color('info')
                ->icon('heroicon-o-calendar'),

            Card::make('Transaksi Minggu Ini', Order::whereBetween('created_at', [Carbon::now()->startOfWeek(), Carbon::now()->endOfWeek()])->count())
                ->description($this->formatTransactions(Carbon::now()->startOfWeek(), Carbon::now()->endOfWeek()))
                ->color('success')
                ->icon('heroicon-o-clock'),

            Card::make('Transaksi Bulan Ini', Order::whereBetween('created_at', [Carbon::now()->startOfMonth(), Carbon::now()->endOfMonth()])->count())
                ->description($this->formatTransactions(Carbon::now()->startOfMonth(), Carbon::now()->endOfMonth()))
                ->color('warning')
                ->icon('heroicon-o-chart-bar'),

            Card::make('Semua Transaksi', Order::count())
                ->description($this->formatTransactions())
                ->color('primary')
                ->icon('heroicon-o-chart-pie'),
        ];
    }

    private function formatTransactions($startDate = null, $endDate = null): string
    {
        $query = Order::query();

        if ($startDate && $endDate) {
            $query->whereBetween('created_at', [$startDate, $endDate]);
        }

        $sukses = $query->clone()->where('buy_status', 'Sukses')->count();
        $pending = $query->clone()->where('buy_status', 'Pending')->count();
        $batal = $query->clone()->where('buy_status', 'Batal')->count();
        $gagal = $query->clone()->where('buy_status', 'Gagal')->count();

        return "Sukses: {$sukses} | Pending: {$pending} | Batal: {$batal} | Gagal: {$gagal}";
    }
}