<?php

namespace App\Filament\Resources\PromoCodeResource\Pages;

use App\Filament\Resources\PromoCodeResource;
use Filament\Resources\Pages\CreateRecord;

class CreatePromoCode extends CreateRecord
{
    protected static string $resource = PromoCodeResource::class;

    protected function mutateFormDataBeforeCreate(array $data): array
    {
        $data['payment_method_ids'] = array_values(array_unique(array_map('intval', (array) ($data['payment_method_ids'] ?? []))));
        $data['game_ids'] = array_values(array_unique(array_map('intval', (array) ($data['game_ids'] ?? []))));
        return $data;
    }

    protected function afterCreate(): void
    {
        $data = $this->form->getState();

        $paymentMethodIds = array_values(array_unique(array_map('intval', (array) ($data['payment_method_ids'] ?? []))));
        $gameIds = array_values(array_unique(array_map('intval', (array) ($data['game_ids'] ?? []))));

        $this->record->paymentMethods()->sync($paymentMethodIds);
        $this->record->games()->sync($gameIds);
    }
}