<?php

namespace App\Filament\Resources;

use App\Filament\Resources\ProductPromotionResource\Pages;
use App\Models\ProductPromotion;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;

class ProductPromotionResource extends Resource
{
    protected static ?string $model = ProductPromotion::class;

    protected static ?string $navigationIcon = 'heroicon-o-tag';
    protected static ?string $navigationGroup = 'Manajemen Produk';
    protected static ?string $navigationLabel = 'Produk Promosi';
    protected static ?string $modelLabel = 'Produk Promosi';
    protected static ?string $pluralModelLabel = 'Produk Promosi';

    public static function form(Form $form): Form
    {
        return $form->schema([
            Forms\Components\Section::make('Pengaturan Promosi')
                ->schema([
                    Forms\Components\Select::make('product_id')
                        ->label('Produk')
                        ->relationship('product', 'title')
                        ->searchable()
                        ->preload()
                        ->required(),

                    Forms\Components\TextInput::make('title')
                        ->label('Judul Promo')
                        ->maxLength(255)
                        ->required(),

                    Forms\Components\TextInput::make('promo_price')
                        ->label('Harga Promo')
                        ->numeric()
                        ->required(),

                    Forms\Components\Toggle::make('is_active')
                        ->label('Aktifkan Promo')
                        ->default(true)
                        ->required(),

                    Forms\Components\DateTimePicker::make('start_at')
                        ->label('Mulai Promo')
                        ->required(),

                    Forms\Components\DateTimePicker::make('end_at')
                        ->label('Selesai Promo')
                        ->helperText('Boleh dikosongkan jika promo tidak punya tanggal berakhir.')
                        ->nullable(),
                ])
                ->columns(2),
        ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('product.title')
                    ->label('Produk')
                    ->searchable()
                    ->sortable(),

                Tables\Columns\TextColumn::make('title')
                    ->label('Judul Promo')
                    ->searchable()
                    ->sortable(),

                Tables\Columns\TextColumn::make('promo_price')
                    ->label('Harga Promo')
                    ->money('IDR')
                    ->sortable(),

                Tables\Columns\IconColumn::make('is_active')
                    ->label('Aktif')
                    ->boolean()
                    ->sortable(),

                Tables\Columns\TextColumn::make('start_at')
                    ->label('Mulai')
                    ->dateTime()
                    ->sortable(),

                Tables\Columns\TextColumn::make('end_at')
                    ->label('Selesai')
                    ->dateTime()
                    ->sortable(),
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListProductPromotions::route('/'),
            'create' => Pages\CreateProductPromotion::route('/create'),
            'edit' => Pages\EditProductPromotion::route('/{record}/edit'),
        ];
    }
}