<?php

namespace App\Filament\Resources;

use App\Filament\Resources\ProductLogoResource\Pages;
use App\Filament\Resources\ProductLogoResource\RelationManagers;
use App\Models\ProductLogo;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class ProductLogoResource extends Resource
{
    protected static ?string $model = ProductLogo::class;
    
    protected static ?string $navigationGroup = 'Manajemen Produk';
    
    protected static ?string $navigationLabel = 'Logo Produk';
    protected static ?string $pluralModelLabel = 'Default Logo Produk';

    protected static ?string $navigationIcon = 'heroicon-o-photo';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\Select::make('brand')
                    ->label('Brand')
                    ->searchable()
                    ->options(fn () => \App\Models\Product::pluck('brand', 'brand')->unique()->toArray())
                    ->required(),
    
                Forms\Components\FileUpload::make('image')
                    ->image()
                    ->disk('public')
                    ->directory('product')
                    ->required(),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('brand')
                    ->searchable(),
                Tables\Columns\ImageColumn::make('image'),
                Tables\Columns\TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListProductLogos::route('/'),
            'create' => Pages\CreateProductLogo::route('/create'),
            'edit' => Pages\EditProductLogo::route('/{record}/edit'),
        ];
    }
}
