<?php

namespace App\Filament\Resources;

use App\Filament\Resources\GameResource\Pages;
use App\Filament\Resources\GameResource\RelationManagers;
use App\Models\Game;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Filament\Forms\Components\RichEditor;

class GameResource extends Resource
{
    protected static ?string $model = Game::class;
    
    protected static ?string $navigationGroup = 'Manajemen Game';
  
    protected static ?string $navigationLabel = 'Game';
    protected static ?string $pluralModelLabel = 'Game';

    protected static ?string $navigationIcon = 'heroicon-o-cube';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\FileUpload::make('image')
                    ->image()
                    ->disk('public')
                    ->directory('game/image')
                    ->required(),
                Forms\Components\FileUpload::make('banner')
                    ->image()
                    ->disk('public')
                    ->directory('game/banner')
                    ->required(),
                Forms\Components\TextInput::make('title')
                    ->required()
                    ->maxLength(191),
                Forms\Components\TextInput::make('developers')
                    ->required()
                    ->maxLength(191),
                Forms\Components\Select::make('brand')
                    ->label('Brand')
                    ->searchable()
                    ->options(fn () => array_merge(
                        ['Null' => 'Tidak Ada'],
                        \App\Models\Product::pluck('brand', 'brand')->unique()->toArray()
                    ))
                    ->required(),
                Forms\Components\Select::make('category_id')
                    ->label('Category')
                    ->relationship('category', 'title')
                    ->searchable()
                    ->preload()
                    ->required(),
                RichEditor::make('description')
                    ->toolbarButtons([
                        'bold',           // Tombol Bold
                        'italic',         // Tombol Italic
                        'underline',      // Tombol Underline
                        'strike',         // Tombol Strikethrough
                        'heading',        // Pilihan Heading
                        'bulletList',     // List dengan bullet
                        'orderedList',    // List dengan angka
                        'blockquote',     // Kutipan
                        'link',           // Tambah hyperlink
                        'image',          // Upload gambar
                        'table',          // Tambah tabel
                        'codeBlock',      // Tambah kode
                    ])
                    ->required()
                    ->columnSpanFull(),
                Forms\Components\Checkbox::make('populer')
                    ->label('Tandai sebagai game populer'),
                Forms\Components\Toggle::make('status')
                    ->required(),
                Forms\Components\TextInput::make('sort')
                    ->required()
                    ->numeric()
                    ->default(0),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\ImageColumn::make('image'),
                Tables\Columns\ImageColumn::make('banner'),
                Tables\Columns\TextColumn::make('title')
                    ->searchable(),
                Tables\Columns\TextColumn::make('developers')
                    ->searchable(),
                Tables\Columns\TextColumn::make('brand')
                    ->searchable(),
                Tables\Columns\TextColumn::make('category.title')
                    ->label('Category')
                    ->sortable()
                    ->searchable(),
                Tables\Columns\TextColumn::make('slug')
                    ->searchable(),
                Tables\Columns\IconColumn::make('status')
                    ->boolean(),
                Tables\Columns\TextColumn::make('sort')
                    ->numeric()
                    ->sortable(),
                Tables\Columns\TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\ViewAction::make(),
                Tables\Actions\EditAction::make(),
                Tables\Actions\DeleteAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }
    
    public static function getNavigationBadge(): ?string
    {
        return (string) \App\Models\Game::count();
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListGames::route('/'),
            'create' => Pages\CreateGame::route('/create'),
            'edit' => Pages\EditGame::route('/{record}/edit'),
        ];
    }
}
