<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    protected $commands = [
        \App\Console\Commands\FetchPaymentChannels::class,
    ];

    protected function schedule(Schedule $schedule)
    {
        $schedule->command('product:fetch-product')
            ->hourly();

        $schedule->command('cek:expire')
            ->everyMinute();
    }

    protected function commands()
    {
        $this->load(__DIR__ . '/Commands');
        require base_path('routes/console.php');
    }
}