<?php

namespace App\Console\Commands;

use App\Models\Order;
use App\Models\QrisPayment;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;

class UpdateExpiredPayments extends Command
{
    protected $signature = 'cek:expire';
    protected $description = 'Cek transaksi yang sudah expired';

    public function handle()
    {
        $now = now();

        $expiredQris = QrisPayment::query()
            ->where('status', 'pending')
            ->where('expires_at', '<=', $now)
            ->orderBy('id')
            ->limit(500)
            ->get();

        foreach ($expiredQris as $qris) {
            $qris->update([
                'status' => 'expired',
                'meta' => array_merge($qris->meta ?? [], [
                    'expired_at' => $now->toDateTimeString(),
                ]),
            ]);

            Order::query()
                ->where('order_id', $qris->order_id)
                ->where('payment_status', 'UNPAID')
                ->where('payment_method', 'SMPQRIS')
                ->update([
                    'payment_status' => 'EXPIRED',
                    'buy_status' => 'Batal',
                ]);

            Log::info('[SMP-QRIS] EXPIRED', [
                'order_id' => $qris->order_id,
                'qris_payment_id' => $qris->id,
            ]);
        }

        $expiredOrders = Order::query()
            ->where('payment_status', 'UNPAID')
            ->where('expired_time', '<=', $now->timestamp)
            ->where('payment_method', '!=', 'SMPQRIS')
            ->update([
                'payment_status' => 'EXPIRED',
                'buy_status' => 'Batal',
            ]);

        $this->info("Expired SMPQRIS: {$expiredQris->count()}, Expired Others: {$expiredOrders}");

        return self::SUCCESS;
    }
}