<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Http\Controllers\ProductDigiflazzController;
use Throwable;

class FetchProductDigiflazz extends Command
{
    protected $signature = 'product:fetch-product';
    protected $description = 'Ambil dan perbarui daftar product dari Digiflazz';

    public function handle(): int
    {
        try {
            $controller = app(ProductDigiflazzController::class);
            $response = $controller->fetchProduct();

            $ok = true;

            if ($response && method_exists($response, 'getStatusCode')) {
                $ok = (int) $response->getStatusCode() < 400;
            }

            if (! $ok) {
                $this->error('Gagal sync produk Digiflazz.');
                return self::FAILURE;
            }

            $this->info('Product updated successfully.');
            return self::SUCCESS;
        } catch (Throwable $e) {
            $this->error('Gagal sync produk Digiflazz: ' . $e->getMessage());
            return self::FAILURE;
        }
    }
}